//
//  NSURL+MPAdditions.h
//  dJAX
//
//  Copyright (c) 2013 dJAX. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum {
    MPdJAXHostCommandUnrecognized,
    MPdJAXHostCommandClose,
    MPdJAXHostCommandFinishLoad,
    MPdJAXHostCommandFailLoad,
    MPdJAXHostCommandPrecacheComplete,
    MPdJAXHostCommandRewardedVideoEnded
} MPdJAXHostCommand;

typedef enum {
    MPdJAXShareHostCommandTweet,
    MPdJAXShareHostCommandUnrecognized
} MPdJAXShareHostCommand;

@interface NSURL (MPAdditions)

- (NSString *)mp_queryParameterForKey:(NSString *)key;
- (NSArray *)mp_queryParametersForKey:(NSString *)key;
- (NSDictionary *)mp_queryAsDictionary;
- (BOOL)mp_hasTelephoneScheme;
- (BOOL)mp_hasTelephonePromptScheme;
- (BOOL)mp_isSafeForLoadingWithoutUserAction;
- (BOOL)mp_isdJAXScheme;
- (MPdJAXHostCommand)mp_dJAXHostCommand;
- (BOOL)mp_isdJAXShareScheme;
- (MPdJAXShareHostCommand)mp_dJAXShareHostCommand;

@end
